<?php

class HypergateAPI {
    private $apiUrl = "https://api.hgi-gaming.xyz/v1/api";
    private $agentToken = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VySWQiOiJjY2M1YThhNC1lYWE3LTRiY2ItYjgzOC05MGQwNGQ3ZDZkZjYiLCJ1c2VybmFtZSI6Inh0ZWFtIiwicm9sZSI6Im1lbWJlciIsImlhdCI6MTc2ODE0MTY4OH0.8G9aD0s5KsvmOkiz1Zsa6Qhps1oATXRGfIumBNxM4QU";

    private function postRequest($data) {
        $ch = curl_init($this->apiUrl);
        $payload = json_encode($data);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        $result = curl_exec($ch);
        curl_close($ch);
        return json_decode($result, true);
    }

    public function provider_list() {
        return $this->postRequest([
            "method" => "provider_list",
            "agent_token" => $this->agentToken
        ]);
    }

    public function game_list($provider_code = null, $game_type = null, $page = 1, $limit = 9999) {
        $data = [
            "method" => "game_list",
            "agent_token" => $this->agentToken,
            "page" => $page,
            "limit" => $limit
        ];
        if ($provider_code) $data['provider_code'] = $provider_code;
        if ($game_type) $data['game_type'] = $game_type;
        return $this->postRequest($data);
    }

    public function launch_game($provider_code, $username, $game_id = "0", $lang = "en-US", $demo = false) {
        return $this->postRequest([
            "method" => "launch_game",
            "agent_token" => $this->agentToken,
            "provider_code" => $provider_code,
            "username" => $username,
            "game_id" => $game_id,
            "lang" => $lang,
            "demo" => $demo
        ]);
    }

    public function get_balance($username = null) {
        $data = [
            "method" => "get_balance",
            "agent_token" => $this->agentToken
        ];
        if ($username) $data['username'] = $username;
        return $this->postRequest($data);
    }

    public function create_user($username) {
        return $this->postRequest([
            "method" => "create_user",
            "agent_token" => $this->agentToken,
            "username" => $username
        ]);
    }

    public function deposit($username, $amount) {
        return $this->postRequest([
            "method" => "deposit",
            "agent_token" => $this->agentToken,
            "username" => $username,
            "amount" => (float)$amount
        ]);
    }

    public function withdraw($username, $amount) {
        return $this->postRequest([
            "method" => "withdraw",
            "agent_token" => $this->agentToken,
            "username" => $username,
            "amount" => (float)$amount
        ]);
    }
}